-- Macro_Scripts File
-- Purpose:  define action for each creatable Particles Systems objects to hook up to the create main menu (or quads)

/*
Revision History

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	24 Mai 2003: Pierre-felix Breton
	created for 3ds MAX 6
	
	Nov 17 1998: Frank Delise
	created
*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

---------------------------------------------------------------------------
macroScript PFFindTarget
            category:~PFFINDTARGET_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFFINDTARGET_TOOLTIP~ 
            buttontext:~PFFINDTARGET_BUTTONTEXT~ 
            --Icon:#("Particles",3)
(
    on execute do StartObjectCreation Find_Target
    on isChecked return mcrUtils.IsCreating Find_Target
)

---------------------------------------------------------------------------
macroScript PFSpeedByIcon
            category:~PFSPEEDBYICON_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFSPEEDBYICON_TOOLTIP~ 
            buttontext:~PFSPEEDBYICON_BUTTONTEXT~ 
            --Icon:#("Particles",3)
(
    on execute do StartObjectCreation SpeedByIcon
    on isChecked return mcrUtils.IsCreating SpeedByIcon
)

---------------------------------------------------------------------------
macroScript PFParticlePaint
            category:~PFPARTICLEPAINT_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFPARTICLEPAINT_TOOLTIP~ 
            buttontext:~PF_PARTICLEPAINT_BUTTONTEXT~
(
    on execute do StartObjectCreation Particle_Paint
    on isChecked return mcrUtils.IsCreating Particle_Paint
)

---------------------------------------------------------------------------
macroScript PFBirthTexture
            category:~PFBIRTHTEXTURE_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFBIRTHTEXTURE_TOOLTIP~ 
            buttontext:~PFBIRTHTEXTURE_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Birth_Texture
    on isChecked return mcrUtils.IsCreating Birth_Texture
)

---------------------------------------------------------------------------
macroScript PFInitialState
            category:~PFINITIALSTATE_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFINITIALSTATE_TOOLTIP~ 
            buttontext:~PFINITIALSTATE_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Initial_State
    on isChecked return mcrUtils.IsCreating Initial_State
)

---------------------------------------------------------------------------
macroScript PFGroupSelect
            category:~PFGROUPSELECT_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFGROUPSELECT_TOOLTIP~ 
            buttontext:~PFGROUPSELECT_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Group_Select
    on isChecked return mcrUtils.IsCreating Group_Select
)

---------------------------------------------------------------------------
macroScript PFSource
            category:~PFSOURCE_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~PFSOURCE_TOOLTIP~ 
            buttontext:~PFSOURCE_BUTTONTEXT~ 
            --Icon:#("Particles",3)
(
    on execute do StartObjectCreation PF_Source
    on isChecked return mcrUtils.IsCreating PF_Source
)
---------------------------------------------------------------------------
macroScript PArray
            category:~PARRAY_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~PARRAY_TOOLTIP~ 
            buttontext:~PARRAY_BUTTONTEXT~ 
            Icon:#("Particles",3)
(
    on execute do StartObjectCreation PArray
    on isChecked return mcrUtils.IsCreating PArray
)
---------------------------------------------------------------------------
macroScript PCloud
            category:~PCLOUD_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~PCLOUD_TOOLTIP~ 
            buttontext:~PCLOUD_BUTTONTEXT~ 
            Icon:#("Particles",6)
(
    on execute do StartObjectCreation PCloud 
    on isChecked return mcrUtils.IsCreating PCloud
)
---------------------------------------------------------------------------
macroScript Blizzard
            category:~BLIZZARD_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~BLIZZARD_TOOLTIP~ 
            buttontext:~BLIZZARD_BUTTONTEXT~ 
            Icon:#("Particles",5)
(
    on execute do StartObjectCreation Blizzard 
    on isChecked return mcrUtils.IsCreating Blizzard
)
---------------------------------------------------------------------------
macroScript SuperSpray
            category:~SUPERSPRAY_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~SUPERSPRAY_TOOLTIP~
			buttontext:~SUPERSPRAY_BUTTONTEXT~ 
            Icon:#("Particles",2)
(
    on execute do StartObjectCreation SuperSpray 
    on isChecked return mcrUtils.IsCreating SuperSpray
)
---------------------------------------------------------------------------
macroScript Spray
            category:~SPRAY_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~SPRAY_TOOLTIP~ 
            buttontext:~SPRAY_BUTTONTEXT~ 
            Icon:#("Particles",1)
(
    on execute do StartObjectCreation Spray
    on isChecked return mcrUtils.IsCreating Spray
)
---------------------------------------------------------------------------
macroScript Snow
            category:~SNOW_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~SNOW_TOOLTIP~ 
            buttontext:~SNOW_BUTTONTEXT~ 
            Icon:#("Particles",4)
(
    on execute do StartObjectCreation Snow 
    on isChecked return mcrUtils.IsCreating Snow
)
